/**
 * EchoClients.java
 * @author dennis
 * Created: Apr 11, 2006
 */
package test;

import java.io.IOException;
import java.util.*;
import java.util.logging.*;

import game.net.*;

/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class EchoClients {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		log = Logger.getLogger("Soccer.team");
		try {
			System.out.println("Log file will be written to: " + 
					System.getProperty("user.home"));
			Handler fh = new FileHandler("%h/soccer_team.log", true);
			fh.setFormatter(new SimpleFormatter());
			log.addHandler(fh);
			log.setLevel(Level.FINEST); // could be set by UI
			
			aSide = new Client_network_layer();
			bSide = new Client_network_layer();
			
			aSide.init("localhost", 23476);
			bSide.init("localhost", 23476);
			aBuff = new StringBuffer();
			bBuff = new StringBuffer();
			
			final int numReps = 30;
			Date start = new Date();
			for (int i = 0; i < numReps; i++) {
				aSide.send_line("A test #" + i + "\n");
				aSide.get_line(aBuff);
				bSide.send_line("B test #" + i + "\n");
				bSide.get_line(bBuff);
			}
			Date end = new Date();
			System.out.println("Average turn-around time for " + numReps + 
					" pairs = " + (double)(end.getTime()-start.getTime())/(numReps*2) + " ms.");
			aSide.send_line("quit\n");
			aSide.get_line(aBuff);
			bSide.send_line("quit\n");
			bSide.get_line(bBuff);
			aSide.shutdown();
			bSide.shutdown();
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		// TODO Auto-generated method stub

	}
	


	private static Logger log;
	private static Client_network_layer aSide;
	private static Client_network_layer bSide;
	private static StringBuffer aBuff;
	private static StringBuffer bBuff;
}
