/**
 * EchoServer.java
 * @author dennis
 * Created: Apr 11, 2006
 */
package test;

import java.io.IOException;
import java.net.UnknownHostException;

import game.net.*;
import java.util.*;
import java.util.logging.*;
/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class EchoServer {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		mNetwork = new Server_network_layer();
		log = Logger.getLogger("Soccer.simulator");
		try {
			System.out.println("Log file will be written to: " + 
					System.getProperty("user.home"));
			Handler fh = new FileHandler("%h/soccer_simulator.log", true);
			fh.setFormatter(new SimpleFormatter());
			log.addHandler(fh);
			log.setLevel(Level.FINEST); // could be set by UI
			
			mNetwork.init(23476);
			mMsgBuffer = new StringBuffer();
			serveRequests();
			mNetwork.shutdown();
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// TODO Auto-generated method stub

	}
	
	static private void serveRequests() throws IOException {
		mStart = new Date();
		do {
			int side = getLine();
			if (side != 0) {
				int tm = (int)((new Date()).getTime() - mStart.getTime());
				mNetwork.send_line("At " + tm + mMsgBuffer.toString(), side);
			} else {
				try {
					Thread.sleep(5);
				} catch (InterruptedException e) {	}				
			}
		} while (!mMsgBuffer.equals("quit\n"));
	}
	
	static private int getLine() throws IOException {
		return mNetwork.get_line(Server_network_interface.WEST |
				Server_network_interface.EAST,
				mMsgBuffer);
	}

	private static Date mStart;
	private static Server_network_layer mNetwork;
	private static Logger log;
    private static StringBuffer mMsgBuffer;

}
