/**
 * SMVectorTest.java
 * @author dennis
 * Created: Mar 12, 2006
 */
package test;

import junit.framework.TestCase;
import simulator.model.*;

/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class SMVectorTest extends TestCase {

	public static void main(String[] args) {
		junit.textui.TestRunner.run(SMVectorTest.class);
	}
	
	public void testCartesianToPoar() {
		SMVector cart = SMVector.makeCartesian(5, 5);
		assertEquals("Magnitude of (5, 5):", Math.sqrt(50), cart.getMagnitude());
		assertEquals("Angle of (5, 5)", (double)45, cart.getAngle(), 0.00001);
		
		cart.setCartesian(5, 3);
		assertEquals("Magnitude of (5, 3):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (5, 3)", (double)30.96, cart.getAngle(), 0.01);
		
		cart.setCartesian(5, 0);
		assertEquals("Magnitude of (5, 0):", (double)5, cart.getMagnitude());
		assertEquals("Angle of (5, 0)", (double)0, cart.getAngle(), 0.00001);
		
		cart.setCartesian(5, -3);
		assertEquals("Magnitude of (5, -3):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (5, -3)", (double)329.04, cart.getAngle(), 0.01);

		cart.setCartesian(5, -5);
		assertEquals("Magnitude of (5, -5):", Math.sqrt(50), cart.getMagnitude());
		assertEquals("Angle of (5, -5)", (double)315, cart.getAngle(), 0.00001);
		
		cart.setCartesian(3, -5);
		assertEquals("Magnitude of (3, -5):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (3, -5)", (double)300.96, cart.getAngle(), 0.01);
		
		cart.setCartesian(0, -5);
		assertEquals("Magnitude of (0, -5):", (double)5, cart.getMagnitude());
		assertEquals("Angle of (0, -5)", (double)270, cart.getAngle(), 0.000001);

		cart.setCartesian(-3, -5);
		assertEquals("Magnitude of (-3, -5):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (-3, -5)", (double)239.04, cart.getAngle(), 0.01);

		cart.setCartesian(-5, -5);
		assertEquals("Magnitude of (-5, -5):", Math.sqrt(50), cart.getMagnitude());
		assertEquals("Angle of (-5, -5)", (double)225, cart.getAngle(), 0.000001);

		cart.setCartesian(-5, -3);
		assertEquals("Magnitude of (-5, -3):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (-5, -3)", (double)210.96, cart.getAngle(), 0.01);

		cart.setCartesian(-5, 0);
		assertEquals("Magnitude of (-5, 0):", (double)5, cart.getMagnitude());
		assertEquals("Angle of (-5, 0)", (double)180, cart.getAngle(), 0.000001);

		cart.setCartesian(-5, 3);
		assertEquals("Magnitude of (-5, 3):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (-5, 3)", (double)149.04, cart.getAngle(), 0.01);

		cart.setCartesian(-5, 5);
		assertEquals("Magnitude of (-5, 5):", Math.sqrt(50), cart.getMagnitude());
		assertEquals("Angle of (-5, 5)", (double)135, cart.getAngle(), 0.000001);

		cart.setCartesian(-3, 5);
		assertEquals("Magnitude of (-3, 5):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (-3, 5)", (double)120.96, cart.getAngle(), 0.01);

		cart.setCartesian(0, 5);
		assertEquals("Magnitude of (0, 5):", (double)5, cart.getMagnitude());
		assertEquals("Angle of (0, 5)", (double)90, cart.getAngle(), 0.000001);

		cart.setCartesian(3, 5);
		assertEquals("Magnitude of (3, 5):", Math.sqrt(34), cart.getMagnitude());
		assertEquals("Angle of (3, 5)", (double)59.04, cart.getAngle(), 0.01);
		
	}
	
	public void testPolarToCartesian() {
		SMVector pol = SMVector.makePolar(10, 0);
		assertEquals("X of (10 ang 0)", (double)10, pol.getX(), 0.00001);
		assertEquals("Y of (10 ang 0)", (double)0, pol.getY(), 0.00001);

		pol.setPolar(10, 30);
		assertEquals("X of (10 ang 30)", 8.66, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 30)", 5.0, pol.getY(), 0.01);
		
		pol.setPolar(10, 45);
		assertEquals("X of (10 ang 45)", 7.07, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 45)", 7.07, pol.getY(), 0.01);
		
		pol.setPolar(10, 60);
		assertEquals("X of (10 ang 60)", 5.0, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 60)", 8.66, pol.getY(), 0.01);
		
		pol.setPolar(10, 90);
		assertEquals("X of (10 ang 90)", (double)0, pol.getX(), 0.00001);
		assertEquals("Y of (10 ang 90)", (double)10, pol.getY(), 0.00001);
		
		pol.setPolar(10, 120);
		assertEquals("X of (10 ang 120)", -5.0, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 120)", 8.66, pol.getY(), 0.01);
		
		pol.setPolar(10, 135);
		assertEquals("X of (10 ang 135)", -7.07, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 135)", 7.07, pol.getY(), 0.01);
		
		pol.setPolar(10, 150);
		assertEquals("X of (10 ang 150)", -8.66, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 150)", 5.0, pol.getY(), 0.01);
		
		pol.setPolar(10, 180);
		assertEquals("X of (10 ang 180)", (double)-10, pol.getX(), 0.00001);
		assertEquals("Y of (10 ang 180)", (double)0, pol.getY(), 0.00001);
		
		pol.setPolar(10, 210);
		assertEquals("X of (10 ang 210)", -8.66, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 210)", -5.0, pol.getY(), 0.01);
		
		pol.setPolar(10, 225);
		assertEquals("X of (10 ang 225)", -7.07, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 225)", -7.07, pol.getY(), 0.01);
		
		pol.setPolar(10, 240);
		assertEquals("X of (10 ang 240)", -5.0, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 240)", -8.66, pol.getY(), 0.01);
		
		pol.setPolar(10, 270);
		assertEquals("X of (10 ang 270)", (double)0, pol.getX(), 0.00001);
		assertEquals("Y of (10 ang 270)", (double)-10, pol.getY(), 0.00001);
		
		pol.setPolar(10, 300);
		assertEquals("X of (10 ang 300)", 5.0, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 300)", -8.66, pol.getY(), 0.01);
		
		pol.setPolar(10, 315);
		assertEquals("X of (10 ang 315)", 7.07, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 315)", -7.07, pol.getY(), 0.01);
		
		pol.setPolar(10, 330);
		assertEquals("X of (10 ang 330)", 8.66, pol.getX(), 0.01);
		assertEquals("Y of (10 ang 330)", -5.0, pol.getY(), 0.01);
		

	}
	
	

}
