/**
 * SimTestCase.java
 * @author dennis
 * Created: Apr 6, 2006
 */
package test;

import java.io.IOException;
import java.util.logging.Logger;

import simulator.model.CartesianVect;

import game.Side;
import game.protocol.AllReply;
import game.protocol.ParseException;
import junit.framework.TestCase;

/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class SimTestCase extends TestCase {

	public SimTestCase(String name) {
		super(name);
	}
	
	protected void setUp() throws Exception {
		super.setUp();
		TestMain.aSide.doInit(Side.EAST);
		TestMain.bSide.doInit(Side.WEST);
		while (!TestMain.aSide.isGameRunning() || !TestMain.bSide.isGameRunning()) Thread.sleep(250);
	}

	protected void tearDown() throws Exception {
		TestMain.aSide.doEnd();
		TestMain.bSide.doEnd();
		while (TestMain.aSide.isGameRunning() || TestMain.bSide.isGameRunning()) Thread.sleep(250);
		super.tearDown();
	}
	
	/**
	 * Check an AllReply to verify the player position.
	 * @param t player team
	 * @param p player number
	 * @param expX expected X coordinate
	 * @param expY expected Y coordinate
	 * @param tol tolerance
	 * @param rep reply contianing informatioon
	 */
	protected void checkPlayerPosition(Side t, int p, double expX, double expY, double tol, AllReply rep) {
		CartesianVect pos = rep.getPlayerPosition(t, p);
		assertEquals("Team " + t + ", Player " + p + " X coordinate", expX, pos.getX(), tol);
		assertEquals("Team " + t + ", Player " + p + " Y coordinate", expY, pos.getY(), tol);
	}

	protected void sleep(int milis) {
		log.fine("Sleep for " + milis + " ms.");
		try {
			Thread.sleep(milis);
		} catch (InterruptedException e) { /* ignored exception */	}
	}
/*	
	public void test_boilerplate() {
		final String tcName = "test_boilerplate";
		log.entering(cName, tcName);
		log.info("Test: Initial Configuration.");
		try {
			// do test stuff
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}
		log.exiting(cName, tcName);		
	}
*/
	protected static Logger log = Logger.getLogger("Soccer.team");

}
