/**
 * 
 */
package test;

import game.Side;
import game.protocol.AllReply;
import game.protocol.ParseException;
import game.protocol.Reply;

import java.io.IOException;

import simulator.model.ISimulatorView;
import simulator.model.SMVector;

/**
 * @author dennis
 *
 */
public class SimTestFoul extends SimTestCase {

	/**
	 * @param name
	 */
	public SimTestFoul(String name) {
		super(name);
	}

	public void test_foul_from_astern() {
		final String tcName = "test_foul_from_astern";
		log.entering(cName, tcName);
		log.info("Test: Foul from directly behind.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to centeline x=20 and (1,1) to x=25.");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(20, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(25, 12.5));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(16.5, 11.5));
			
			log.fine("Spin (0,1) 180 degrees (2 sec @ 90 deg/sec).");
			TestMain.bSide.spin(2000, 1, 90);
			TestMain.bSide.spin(4000, 1, 0);
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s.");
			TestMain.aSide.accelerate(5000, 1, 1);
			TestMain.bSide.accelerate(5000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 0);
			// Foul should occur after 4 s.
			rep = TestMain.aSide.sendAllRequestUntil(9100);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}

	public void test_foul_from_abaft_port_beam() {
		final String tcName = "test_foul_from_abaft_port_beam";
		log.entering(cName, tcName);
		log.info("Test: Foul from behind, left side.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to (21.5, 12.5) and (1,1) to (19.34, 8.17).");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(21.5, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(19.34, 8.17));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(16.5, 13.5));
			
			log.fine("Spin (0,1) 180 degrees (2 sec @ 90 deg/sec).");
			TestMain.bSide.spin(2000, 1, 90);
			TestMain.bSide.spin(4000, 1, 0);
			log.fine("Spin (1,1) 60 degrees (2 sec @ -30 deg/sec).");
			TestMain.aSide.spin(3000, 1, -30);
			TestMain.aSide.spin(5000, 1, 0);
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s.");
			TestMain.aSide.accelerate(8000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 1);
			TestMain.bSide.accelerate(7000, 1, 0);
			// Foul should occur after 4 s.
			rep = TestMain.aSide.sendAllRequestUntil(12100);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame.", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}
	
	public void test_foul_from_abaft_stbrd_beam() {
		final String tcName = "test_foul_from_abaft_stbrd_beam";
		log.entering(cName, tcName);
		log.info("Test: Foul from behind, right side.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to (21.5, 12.5) and (1,1) to (19.34, 16.83).");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(21.5, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(19.34, 16.83));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(16.5, 11.5));
			
			log.fine("Spin (0,1) 180 degrees (2 sec @ 90 deg/sec).");
			TestMain.bSide.spin(2000, 1, 90);
			TestMain.bSide.spin(4000, 1, 0);
			log.fine("Spin (1,1) 60 degrees (2 sec @ 30 deg/sec).");
			TestMain.aSide.spin(3000, 1, 30);
			TestMain.aSide.spin(5000, 1, 0);
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s.");
			TestMain.aSide.accelerate(8000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 1);
			TestMain.bSide.accelerate(7000, 1, 0);
			// Foul should occur after 4 s.
			rep = TestMain.aSide.sendAllRequestUntil(12100);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame.", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}
	
	public void test_foul_from_ford_port_beam() {
		final String tcName = "test_foul_from_ford_port_beam";
		log.entering(cName, tcName);
		log.info("Test: Foul from ahead, left side.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to (21.5, 12,5) and (1,1) to (13.66, 8.17).");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(21.5, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(14.16, 8.17));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(16.5, 13.5));
			
			log.fine("Spin (0,1) 180 degrees (2 sec @ 90 deg/sec).");
			TestMain.bSide.spin(2000, 1, 90);
			TestMain.bSide.spin(4000, 1, 0);
			log.fine("Spin (1,1) 120 degrees (2 sec @ -60 deg/sec).");
			TestMain.aSide.spin(3000, 1, -60);
			TestMain.aSide.spin(5000, 1, 0);
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s.");
			TestMain.aSide.accelerate(8000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 1);
			TestMain.bSide.accelerate(7000, 1, 0);
			// Foul should occur after 4 s.
			rep = TestMain.aSide.sendAllRequestUntil(12100);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame.", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}

	
	public void test_foul_from_ford_stbrd_beam() {
		final String tcName = "test_foul_from_ford_stbrd_beam";
		log.entering(cName, tcName);
		log.info("Test: Foul from ahead, right side.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to (21.5, 12,5) and (1,1) to (13.66, 16.83).");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(21.5, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(14.16, 16.83));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(16.5, 11.5));
			
			log.fine("Spin (0,1) 180 degrees (2 sec @ 90 deg/sec).");
			TestMain.bSide.spin(2000, 1, 90);
			TestMain.bSide.spin(4000, 1, 0);
			log.fine("Spin (1,1) 120 degrees (2 sec @ 60 deg/sec).");
			TestMain.aSide.spin(3000, 1, 60);
			TestMain.aSide.spin(5000, 1, 0);
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s.");
			TestMain.aSide.accelerate(8000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 1);
			TestMain.bSide.accelerate(7000, 1, 0);
			// Foul should occur after 4 s.
			rep = TestMain.aSide.sendAllRequestUntil(12100);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}
	
	public void test_foul_from_ahead_A() {
		final String tcName = "test_foul_from_ahead_A";
		log.entering(cName, tcName);
		log.info("Test: Foul from directly ahead, East is faster.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to centeline x=20 and (1,1) to x=25.");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(20, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(25, 12.5));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(21.82, 11.5));
			
			log.fine("Accelerate (1,1) to 5 m/s and (0,1) to 1 m/s");
			TestMain.aSide.accelerate(5000, 1, 1);
			TestMain.bSide.accelerate(5000, 1, 1);
			TestMain.bSide.accelerate(6000, 1, 0);
			// Foul should occur after 2.32 s.
			rep = TestMain.aSide.sendAllRequestUntil(7500);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame.", ar.isPlayerInGame(TestMain.aSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}

	public void test_foul_from_ahead_B() {
		final String tcName = "test_foul_from_ahead_B";
		log.entering(cName, tcName);
		log.info("Test: Foul from directly ahead, West is faster.");
		Reply rep;
		try {
			log.fine("Move player (0,1) to centeline x=20 and (1,1) to x=25");
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(20, 12.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(25, 12.5));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(23.18, 11.5));
			
			log.fine("Accelerate (1,1) to 1 m/s and (0,1) to 5 m/s.");
			TestMain.aSide.accelerate(5000, 1, 1);
			TestMain.bSide.accelerate(5000, 1, 1);
			TestMain.aSide.accelerate(6000, 1, 0);
			// Foul should occur after 2.32 s.
			rep = TestMain.aSide.sendAllRequestUntil(7500);
			AllReply ar = (AllReply)rep;
			assertFalse("Player committed foul isPlayerInGame.", ar.isPlayerInGame(TestMain.bSide.getSide(), 1));
			//rep = TestMain.bSide.sendAllRequestUntil(15000); // let me watch a bit more.
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}

	public void test_foul_last_man_standing() {
		final String tcName = "test_foul_last_man_standing";
		log.entering(cName, tcName);
		log.info("Test: Foul from all crash together.");
		Reply rep;
		try {
			log.fine("Move players to 5m radius circle centered at (25,12.5).");
			TestMain.bSide.place_player(0, 0, SMVector.makeCartesian(21.464, 8.964));
			TestMain.bSide.place_player(0, 1, SMVector.makeCartesian(20, 12.5));
			TestMain.bSide.place_player(0, 2, SMVector.makeCartesian(20.67, 15));
			TestMain.bSide.place_player(0, 3, SMVector.makeCartesian(22.5, 16.83));
			TestMain.bSide.place_player(0, 4, SMVector.makeCartesian(25, 17.5));
			TestMain.aSide.place_player(0, 0, SMVector.makeCartesian(25, 7.5));
			TestMain.aSide.place_player(0, 1, SMVector.makeCartesian(27.5, 8.17));
			TestMain.aSide.place_player(0, 2, SMVector.makeCartesian(29.33, 10));
			TestMain.aSide.place_player(0, 3, SMVector.makeCartesian(30, 12.5));
			TestMain.aSide.place_player(0, 4, SMVector.makeCartesian(28.536, 16.035));
			log.fine("Move ball so that collision shows on zoom view.");
			TestMain.bSide.place_ball(0, SMVector.makeCartesian(25, 12.5));
			log.fine("Turn all players to face center");
			TestMain.bSide.spin(2000, 0, 45);
			TestMain.bSide.spin(3000, 0, 0);
			TestMain.bSide.spin(2500, 2, -30);
			TestMain.bSide.spin(3500, 2, 0);
			TestMain.bSide.spin(4000, 3, -60);
			TestMain.bSide.spin(5000, 3, 0);
			TestMain.bSide.spin(4500, 4, -90);
			TestMain.bSide.spin(5500, 4, 0);
			TestMain.aSide.spin(6000, 0, -90);
			TestMain.aSide.spin(7000, 0, 0);
			TestMain.aSide.spin(6500, 1, -60);
			TestMain.aSide.spin(7500, 1, 0);
			TestMain.aSide.spin(8000, 2, -30);
			TestMain.aSide.spin(9000, 2, 0);
			TestMain.aSide.spin(8500, 4, 45);
			TestMain.aSide.spin(9500, 4, 0);
			log.fine("Accelerate all players to full speed");
			TestMain.aSide.accelerate(10000, 0, 1);
			TestMain.aSide.accelerate(10000, 1, 1);
			TestMain.aSide.accelerate(10000, 2, 1);
			TestMain.aSide.accelerate(10000, 3, 1);
			TestMain.aSide.accelerate(10000, 4, 1);
			TestMain.bSide.accelerate(10000, 0, 1);
			TestMain.bSide.accelerate(10000, 1, 1);
			TestMain.bSide.accelerate(10000, 2, 1);
			TestMain.bSide.accelerate(10000, 3, 1);
			TestMain.bSide.accelerate(10000, 4, 1);
			log.fine("After 4 s only one player should be in play");
			rep = TestMain.aSide.sendAllRequestUntil(14000);
			AllReply ar = (AllReply)rep;
			int numInPlay = 0;
			for (int p = 0; p < ISimulatorView.NUMBER_OF_PLAYERS; p++) {
				if (ar.isPlayerInGame(Side.WEST, p)) numInPlay++;
				if (ar.isPlayerInGame(Side.EAST, p)) numInPlay++;
			}
			assertEquals("Wrong number of players left in play.", 1, numInPlay);
			
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}

		log.exiting(cName, tcName);		
	}

	private static final String cName = "SimTestFoul";

}
