/**
 * SimTestGame.java
 * @author dennis
 * Created: Apr 6, 2006
 */
package test;

import java.io.IOException;

import game.protocol.*;
import game.*;
import simulator.model.*;

/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class SimTestGame extends SimTestCase {

	/**
	 * @param name
	 */
	public SimTestGame(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}
	
	public void test_goal_scoring() {
		final String tcName = "test_goal_scoring";
		log.entering(cName, tcName);
		log.info("Test: Goal Scoring.");
		try {
			// Score in goal 0 with a kick from player (0,2). ==============================
	        // Put the ball down and to the left of player (0,2).
	        TestMain.bSide.place_ball(0, SMVector.makeCartesian(9.301544816, 17.255540686)) ;
	        
	        // At 200 ms, kick the ball head-on with velocity 10.0 m/s
	        TestMain.bSide.kick( 200, 2, 10.0, 0.0 ) ;
	        
	        // Wait for two seconds past the kick request, 
			// long enough for the ball to roll into the goal.
			sleep(2200);
	
			// Send any request from team 0 - reply should be a goal.
			Reply rep = TestMain.bSide.spin(0, 4, 10);
			assertEquals("Reply type", Reply.ReplyType.GOAL, rep.getType());
	
			// Send any request from team 1 - reply should be a goal.
			rep = TestMain.aSide.spin(0, 4, 10);
			assertEquals("Reply type", Reply.ReplyType.GOAL, rep.getType());
	
			// Score in goal 1 with a kick from player (1,2). ==============================
	        // Put the ball up and to the right of player (1,2).
	        TestMain.aSide.place_ball(0, SMVector.makeCartesian(40.698455184, 7.744459314)) ;
	        
	        // At 2500 ms, kick the ball head-on with velocity 10.0 m/s
	        TestMain.aSide.kick( 2500, 2, 10.0, 0.0 ) ;
	        
	        // Wait for two seconds past the kick request, 
			// long enough for the ball to roll into the goal.
			sleep(5500);
	
			// Send any request from team 0 - reply should be a goal.
	        rep = TestMain.bSide.spin(0, 4, 10);
			assertEquals("Reply type", Reply.ReplyType.GOAL, rep.getType());
	
			// Send any request from team 1 - reply should be a goal.
	        rep = TestMain.aSide.spin(0, 4, 10);
			assertEquals("Reply type", Reply.ReplyType.GOAL, rep.getType());
		  // do the test stuff.
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}
		log.exiting(cName, tcName);		
	}


	/**
	 * Test the reset feature.
	 * If for 30 seconds there has been no goal, no reset, 
	 * and the ball has not been kicked by either team, bounced off any player, 
	 * or bounced off any side or post, then the game is reset to the initial 
	 * configuration.
	 */
	public void test_reset() {
		final String tcName = "test_reset";
		log.entering(cName, tcName);
		log.info("Test: Reset.");
		try {
	           // Alter the configuration by placing the ball somewhere other 
            // then the goal line.
			TestMain.aSide.place_ball( 200, SMVector.makeCartesian(20, 10 ));

            // Do nothing for 35 seconds
            log.fine("Wait for  35 seconds") ;
            sleep( 35000 );

			// Check that the initial ball position has been reset to x = 25.
            Reply rep = TestMain.aSide.getGameData();
            assertEquals("Reply type", Reply.ReplyType.RESET, rep.getType());
			AllReply ar = (AllReply)TestMain.aSide.getGameData();
			CartesianVect ballP = ar.getBallPosition();
			assertEquals("Ball position X", 25.0, ballP.getX(), 0.001);
			assertEquals("Ball position Y", 12.5, ballP.getY(), 11.5001);
			
//			pass &= sufficiently_equal(ar.ball_x, 25.0, 0.001);
//			pass &= sufficiently_equal(ar.ball_y, 12.5, 11.5001);
			
			// HOw about team 1?
			rep = TestMain.bSide.getGameData();
            assertEquals("Reply type", Reply.ReplyType.RESET, rep.getType());
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}
		log.exiting(cName, tcName);		
	}
	
	private static final String cName = "SimTestGame";

}
