/**
 * SimTestSetup.java
 * @author dennis
 * Created: Apr 6, 2006
 */
package test;

import java.io.IOException;
import java.util.logging.Logger;

import game.protocol.*;
import game.*;
import simulator.model.*;
import junit.framework.TestCase;

/**
 * @version $Revision: 316 $ $Date: 2008-01-22 23:16:24 -0330 (Tue, 22 Jan 2008) $
 */
public class SimTestSetup extends SimTestCase {

	/**
	 * @param name
	 */
	public SimTestSetup(String name) {
		super(name);
		// TODO Auto-generated constructor stub
	}

	/**
	 * Test that the initial setup is correct.
	 */
	public void test_initial_config() {
		final String tcName = "test_initial_config";
		log.entering(cName, tcName);
		log.info("Test: Initial Configuration.");
		try {
	        // Check that players are placed and oriented properly at start.
			AllReply rep = (AllReply)TestMain.aSide.sendAllRequestUntil(200) ;
	        
	        // Check positions of all the players - the fuzz is very small
	        // since this part at least should be exact.
	
	        // team 0
			checkPlayerPosition(Side.WEST, 0, 2.5, 12.5, 0.001, rep);
			checkPlayerPosition(Side.WEST, 1, 10.0, 7.5, 0.001, rep);
			checkPlayerPosition(Side.WEST, 2, 10.0, 17.5, 0.001, rep);
			checkPlayerPosition(Side.WEST, 3, 20.0, 7.5, 0.001, rep);
			checkPlayerPosition(Side.WEST, 4, 20.0, 17.5, 0.001, rep);
	
	        // team 1
			checkPlayerPosition(Side.EAST, 0, 47.5, 12.5, 0.001, rep);
			checkPlayerPosition(Side.EAST, 1, 40.0, 17.5, 0.001, rep);
			checkPlayerPosition(Side.EAST, 2, 40.0, 7.5, 0.001, rep);
			checkPlayerPosition(Side.EAST, 3, 30.0, 17.5, 0.001, rep);
			checkPlayerPosition(Side.EAST, 4, 30.0, 7.5, 0.001, rep);
	
	        // Check player velocities (should be 0) and orientations.
	        // Note that the acceleration and spinning are checked as well, since
	        // we wait 200ms...if they are accelerating or spinning, the orientation
	        // and velocity will be changed.
	        for (Side teamnum : Side.values())
	        {
	            for (int playernum=0; playernum < 5; playernum++)
	            {
	            	PolarVect vel = rep.getPlayerVelocity(teamnum, playernum);
	            	assertEquals("Team " + teamnum + ", Player " + playernum + " velocity", 0.0, vel.getMagnitude(), 0.001);
	                if (teamnum == Side.WEST)
	                  	assertEquals("Team " + teamnum + ", Player " + playernum + " direction", 0.0, vel.getAngle(), 0.001);
	                else
	                  	assertEquals("Team " + teamnum + ", Player " + playernum + " direction", 180.0, vel.getAngle(), 0.001);
	            }
	        }
	
	        // Check initial ball position -- should be on the centre line ===============
	        rep = (AllReply)TestMain.bSide.getGameData();
	        CartesianVect ballPos = rep.getBallPosition();
	        assertEquals("Ball position X", 25.0, ballPos.getX(), 0.001);
	        assertEquals("Ball position Y", 12.5, ballPos.getY(), 11.5001);
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}
		log.exiting(cName, tcName);		
	}
	
	public void test_performance() {
		final String tcName = "test_performance";
		log.entering(cName, tcName);
		log.info("Test: Performance.");
		try {
			final int numReps = 100;
			int totalDiff = 0;
			for (int i = 0; i < numReps; i++) {
				ControlReply crA = (ControlReply)TestMain.aSide.spin(0, 0, 10);
				ControlReply crB = (ControlReply)TestMain.bSide.spin(0, 0, -10);
				totalDiff += crB.getTime() - crA.getTime();
			}
			if (totalDiff/numReps > 100) {
				fail("Spin replies should be faster. Delay = " + totalDiff/numReps);
			}
			AllReply arA;
			AllReply arB;
			totalDiff = 0;
			for (int i = 0; i < numReps; i++) {
				arA = (AllReply)TestMain.aSide.getGameData();
				arB = (AllReply)TestMain.bSide.getGameData();
				totalDiff += arB.getTime() - arA.getTime();
			}
			if (totalDiff/numReps > 100) {
				fail("All replies should be faster. Delay = " + totalDiff/numReps);
			}
			
			// do test stuff
		} catch (IOException e) {
			fail("IOException:" + e);
		} catch (ParseException e) {
			fail("ParseException: " + e);
		}
		log.exiting(cName, tcName);		
	}
	
	private static final String cName = "SimTestSetup";

}
