/**
 * TestMain.java
 * @author dpeters
 * Created: Mar 6, 2006
 */
package test;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import game.net.SCORETeam;
import game.Student;
import junit.framework.*;
/**
 * @author dpeters
 *
 */
public class TestMain {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		log = Logger.getLogger("Soccer.team");
		try {
			System.out.println("Log file will be written to: " + 
					System.getProperty("user.home"));
			Handler fh = new FileHandler("%h/soccer_team.log", true);
			fh.setFormatter(new SimpleFormatter());
			log.addHandler(fh);
			log.setLevel(Level.FINE); // could be set by UI
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		String modelName;
		try {
			modelName = args[0];
		} catch (ArrayIndexOutOfBoundsException e) {
			modelName = "dpeters";
		}
		Student model = Student.valueOf(modelName);
		aSide = new SimConnector(model, Student.debug);
		bSide = new SimConnector(model, Student.debug);
		Thread aThread = new Thread(aSide);
		Thread bThread = new Thread(bSide);
		aThread.start();
		bThread.start();
		try {
			while (!aSide.isReady() || !bSide.isReady()) Thread.sleep(250);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		log.info("Running tests.");
		TestSuite suite = new TestSuite(SimTestSetup.class);
		suite.addTestSuite(SimTestPlayer.class);
		suite.addTestSuite(SimTestBall.class);
		suite.addTestSuite(SimTestBounce.class);
		suite.addTestSuite(SimTestGame.class);
		suite.addTestSuite(SimTestFoul.class);
		
		junit.textui.TestRunner.run(suite);
		aSide.doQuit();
		bSide.doQuit();

	}
	
	public static SimConnector aSide;
	public static SimConnector bSide;

	private static Logger log;

}
